//
//  BPMViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/5/18.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "BPMViewController.h"

@implementation BPMViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    switch (self.menuInfo.deviceType) {
        case DeviceType3GBP:
            [self connect3GBP];
            [self.sdk device:@[self.bp3g]];
            break;
        case DeviceType4GBP:
            [self connect4GBP];
            [self.sdk device:@[self.bp4g]];
            break;
        case DeviceType5GBP:
            [self connect5GBP];
            [self.sdk device:@[self.bp5g]];
            break;
        default:
            break;
    }
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice device：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    // Disconnect Device
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (self.menuInfo.deviceType) {
        case DeviceType3GBP:
            [self com3G:sender Log:log];
            break;
        case DeviceType4GBP:
            [self com4G:sender Log:log];
            break;
        case DeviceType5GBP:
            [self com5G:sender Log:log];
            break;
        default:
            break;
    }
}

- (void)com3G:(UIButton *)sender Log:(NSString *)log {
    switch (sender.tag) {
        case 100:
            [self.bp3g readHistorys];
            break;
        case 101:
            [self.bp3g clearAllHistorys];

            break;
        case 102:
            [self.bp3g disconnect];
            break;
        case 103:
            [self.bp3g readUserAndVersionData];
            break;
        case 104:
        {
            NSString *ID = [self getBPMuserID];
            NSInteger age = [self getAge];
            [self saveNSUserDefaults:ID Key:@"bpmUserID"];
            [self.bp3g writeUserData:ID Age:age];
            log = [log stringByAppendingFormat:@"：%@ age:%ld",ID, age];
        }
            break;
        case 105:
            [self.bp3g readLastData];
            break;
        case 106:
            [self.bp3g clearLastData];
            break;
        case 107:
            [self.bp3g readDeviceInfo];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

- (void)com4G:(UIButton *)sender Log:(NSString *)log {
    switch (sender.tag) {
        case 100:
            [self.bp4g readHistorys];
            break;
        case 101:
            [self.bp4g clearAllHistorys];
            break;
        case 102:
            [self.bp4g disconnect];
            break;
        case 103:
            [self.bp4g readUserAndVersionData];
            break;
        case 104:
        {
            NSString *ID = [self getBPMuserID];
            NSInteger age = [self getAge];
            [self saveNSUserDefaults:ID Key:@"bpmUserID"];
            [self.bp4g writeUserData:ID Age:age];
            log = [log stringByAppendingFormat:@"：%@ age:%ld",ID, age];
        }
            break;
        case 105:
            [self.bp4g readLastData];
            break;
        case 106:
            [self.bp4g clearLastData];
            break;
        case 107:
            [self.bp4g readDeviceInfo];
            break;
        case 108:
            [self.bp4g readDeviceTime];
            break;
        case 109:
            [self.bp4g syncTiming];
            break;
        case 110:
            [self.bp4g readSerialNumber];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

- (void)com5G:(UIButton *)sender Log:(NSString *)log {
    switch (sender.tag) {
        case 100:
            [self.bp5g readHistorys];
            break;
        case 101:
            [self.bp5g clearAllHistorys];
            break;
        case 102:
            [self.bp5g disconnect];
            break;
        case 103:
            [self.bp5g readUserAndVersionData];
            break;
        case 104:
        {
            NSString *ID = [self getBPMuserID];
            NSInteger age = [self getAge];
            [self saveNSUserDefaults:ID Key:@"bpmUserID"];
            [self.bp5g writeUserData:ID Age:age];
            log = [log stringByAppendingFormat:@"：%@ age:%ld",ID, age];
        }
            break;
        case 105:
            [self.bp5g readLastData];
            break;
        case 106:
            [self.bp5g clearLastData];
            break;
        case 107:
            [self.bp5g readDeviceInfo];
            break;
        case 108:
            [self.bp5g readDeviceTime];
            break;
        case 109:
            [self.bp5g syncTiming];
            break;
        case 110:
            [self.bp5g readSerialNumber];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}

#pragma mark - device
- (void)connect3GBP {
    kWeakSelf(self)
    self.bp3g = [MicroLife3GBP shareWhithAuthorizationkey:SDKkey_BPM];
    [self.bp3g getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bp3g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp3g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD3GReadHistorys:
            case CMD3GClearAllHistorys:
            case CMD3GReadUserAndVersionData:
            case CMD3GWriteUser:
            case CMD3GReadLastData:
            case CMD3GClearLastData:
            case CMD3GReadDeviceInfo:
                break;
            default:
                break;
        }
    }];
}

- (void)connect4GBP {
    kWeakSelf(self)
    self.bp4g = [MicroLife4GBP shareWhithAuthorizationkey:SDKkey_BPM];
    [self.bp4g getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bp4g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp4g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD4GReadHistorys:
            case CMD4GClearAllHistorys:
            case CMD4GReadUserAndVersionData:
            case CMD4GWriteUser:
            case CMD4GReadDeviceInfo:
            case CMD4GReadDeviceTime:
            case CMD4GSyncTiming:
            case CMD4GCheckTransmit:
                break;
            default:
                break;
        }
    }];
}

- (void)connect5GBP {
    kWeakSelf(self)
    self.bp5g = [MicroLife5GBP shareWhithAuthorizationkey:SDKkey_BPM];
    /// Walgreens Device Model
    [self.bp5g getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bp5g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp5g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD5GReadHistorys:
            case CMD5GClearAllHistorys:
            case CMD5GReadUserAndVersionData:
            case CMD5GWriteUser:
            case CMD5GReadDeviceInfo:
            case CMD5GReadDeviceTime:
            case CMD5GSyncTiming:
            case CMD5GCheckTransmit:
                break;
            default:
                break;
        }
    }];
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
