//
//  UIView+PFInputViewControl.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by willy.wu on 2021/8/17.
//  Copyright © 2021 WiFi@MBP. All rights reserved.
//

#import "UIView+PFInputViewControl.h"

@implementation UIView (PFInputViewControl)

- (void)setupKeyboardShow:(void(^)(NSNotification *notifacation))showblock hide:(void (^)(NSNotification *notifacation))hideblock {
      NSNotificationCenter *notificationCenter = [NSNotificationCenter defaultCenter];
      NSOperationQueue *mainQuene = [NSOperationQueue mainQueue];
      [notificationCenter addObserverForName:UIKeyboardWillShowNotification object:nil queue:mainQuene usingBlock:showblock];

      [notificationCenter addObserverForName:UIKeyboardWillHideNotification object:nil queue:mainQuene usingBlock:hideblock];

     //Setting tap hid gesture when the keyboard is showed and remove the tap gesture when it disappear
     [self setupForDismissKeyboard];
}

- (void)setupForDismissKeyboard {
     NSNotificationCenter *notificationCenter = [NSNotificationCenter defaultCenter];
     UITapGestureRecognizer *singleTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(tapHidAction)];

     __weak typeof(self)weakSelf = self;
     NSOperationQueue *mainQuene = [NSOperationQueue mainQueue];
     [notificationCenter addObserverForName:UIKeyboardWillShowNotification object:nil queue:mainQuene usingBlock:^(NSNotification * _Nonnull note) {
         [weakSelf addGestureRecognizer:singleTap];
     }];

     [notificationCenter addObserverForName:UIKeyboardWillHideNotification object:nil queue:mainQuene usingBlock:^(NSNotification * _Nonnull note) {
         [weakSelf removeGestureRecognizer:singleTap];
     }];
 }

@end
