//
//  MenuInfo.h
//  MicroLifeDeviceSDK-Demo
//
//  Created by 吳憲有 on 2022/12/8.
//  Copyright © 2022 WiFi@MBP. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>
#import "IdeabusToolBox.h"

NS_ASSUME_NONNULL_BEGIN

@interface MenuInfo : NSObject

@property (nonatomic, strong) NSString *UUID;

@property (nonatomic, assign) MicroLifeDeviceType deviceType;

@property (nonatomic, strong) NSString *title;

@property (nonatomic, strong) NSString *name;

@property (nonatomic, strong) NSNumber *RSSI;

@property (nonatomic, strong) NSData *mac;

@property (nonatomic, assign) NSInteger bt_code;

@property (nonatomic, strong) UIColor *backgroundColor;

@property (nonatomic, strong) UIColor *textColor;

@property (nonatomic, strong) id device;

+ (NSMutableArray *)menus;

- (void)removalInfo;

- (void)addDevice:(MicroLifeDevice *)device;

@end

NS_ASSUME_NONNULL_END
