 //
//  OFAViewController.m
//  MicroLifeDeviceSDK-Dome
//
//  Created by WiFi@ on 2018/6/5.
//  Copyright © 2018年 WiFi@MBP. All rights reserved.
//

#import "OFAViewController.h"

@implementation OFAViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self connect3GBP];
    [self connect4GBP];
    [self connect5GBP];
    [self connectTemperature];
    [self connectOxygen];
    [self connectWeight];
    [self connectBGM700];
    [self connectBGM800];
    [self connectWatchBPOfficeLTC];
    [self connectWatchBPOffice];
    [self connectWatchBPHome];
    [self connectPFM];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma device
- (void)connect3GBP {
    kWeakSelf(self)
    self.bp3g = [MicroLife3GBP shareWhithAuthorizationkey:SDKkey_BPM];
    [self.bp3g getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"bp3g DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"bp3g ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"bp3g Cancel Scan"];
        [weakself.bp3g startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"bp3g Cancel All Devices Connection"];
        [weakself.bp3g startScan];
    }];
    [self.bp3g deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bp3g];
        [weakself addLogWhitText:log];
    }];
    [self.bp3g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp3g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD3GReadUserAndVersionData:
                [weakself.bp3g readHistorys];
                break;
            case CMD3GReadHistorys:
                [weakself.bp3g disconnect];
                break;
            default:
                break;
        }
    }];
}

- (void)connect4GBP {
    kWeakSelf(self)
    self.bp4g = [MicroLife4GBP shareWhithAuthorizationkey:SDKkey_BPM];
    [self.bp4g addDeviceModel:@[@"6024N",@"BPHJC2-D"]];
    [self.bp4g getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"bp4g DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"bp4g ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"bp4g Cancel Scan"];
        [weakself.bp4g startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"bp4g Cancel All Devices Connection"];
        [weakself.bp4g startScan];
    }];
    [self.bp4g deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bp4g];
        [weakself addLogWhitText:log];
    }];
    [self.bp4g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp4g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD4GReadUserAndVersionData:
                [weakself.bp4g readHistorys];
                break;
            case CMD4GReadHistorys: {
                MicroLifeBloodPressureDRecord *record = model;
                /// 印出解析後的資料 print parse
                NSLog(@"MicroLifeBloodPressureDRecord:%@",record.parseDictionary);
                /// 印出量測血壓的資料 print blood pressure data
                for (MicroLifeBloodPressureCurrentAndMData *data in record.MData ) {
                    NSLog(@"MicroLifeBloodPressureCurrentAndMData:%@",data.parseDictionary);
                }
            }
                [weakself.bp4g disconnect];
                break;
            default:
                break;
        }
    }];
}

- (void)connect5GBP {
    kWeakSelf(self)
    self.bp5g = [MicroLife5GBP shareWhithAuthorizationkey:SDKkey_BPM];
    [self.bp5g getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"bp5g DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"bp5g ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"bp5g Cancel Scan"];
        [weakself.bp5g startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"bp5g Cancel All Devices Connection"];
        [weakself.bp5g startScan];
    }];
    [self.bp5g deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bp5g];
        [weakself addLogWhitText:log];
    }];
    [self.bp5g getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bp5g CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMD5GReadUserAndVersionData:
                [weakself.bp5g readHistorys];
                break;
            case CMD5GReadHistorys: {
                MicroLifeBloodPressureDRecord *record = model;
                /// 印出解析後的資料 print parse
                NSLog(@"MicroLifeBloodPressureDRecord:%@",record.parseDictionary);
                /// 印出量測血壓的資料 print blood pressure data
                for (MicroLifeBloodPressureCurrentAndMData *data in record.MData ) {
                    NSLog(@"MicroLifeBloodPressureCurrentAndMData:%@",data.parseDictionary);
                }
            }
                [weakself.bp5g disconnect];
                break;
            default:
                break;
        }
    }];
}

- (void)connectTemperature {
    kWeakSelf(self)
    self.temperature = [MicroLifeTemperature shareWhithAuthorizationkey:SDKkey_BT];
    [self.temperature addDeviceModel:@[@"FR1MZ1-B"]];
    [self.temperature getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"temperature DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"temperature ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"temperature Cancel Scan"];
        [weakself.temperature startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"temperature Cancel All Devices Connection"];
        [weakself.temperature startScan];
    }];
    [self.temperature deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.temperature];
        [weakself addLogWhitText:log];
    }];
    [self.temperature getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.temperature CMD:CMD Model:model Error:error];
    }];
}

- (void)connectOxygen {
    kWeakSelf(self)
    self.oxygen = [MicroLifeOxygen shareWhithAuthorizationkey:SDKkey_SPO2];
    [self.oxygen getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"oxygen DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"oxygen ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"oxygen Cancel Scan"];
        [weakself.oxygen startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"oxygen Cancel All Devices Connection"];
        [weakself.oxygen startScan];
    }];
    [self.oxygen deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.oxygen];
        [weakself addLogWhitText:log];
    }];
    [self.oxygen getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.oxygen CMD:CMD Model:model Error:error];
    }];
}

- (void)connectWeight {
    kWeakSelf(self)
    self.weight = [MicroLifeWS500 shareWhithAuthorizationkey:SDKkey_WEI];
    [self.weight getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"weight DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"weight ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"weight Cancel Scan"];
        [weakself.weight startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"weight Cancel All Devices Connection"];
        [weakself.weight startScan];
    }];
    [self.weight deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.weight];
        [weakself addLogWhitText:log];
    }];
    [self.weight getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.weight CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWS500WakeUpScale:
                [weakself addLogWhitText:@"WakeUp Scale"];
                [weakself.weight writeUserData:weakself.currUser.userNo.integerValue ID:weakself.currUser.weightUserID Age:weakself.currUser.age.integerValue Gender:weakself.currUser.gender Height:weakself.currUser.height.integerValue UnitType:weakself.currUser.unitType Weight:weakself.currUser.weight.floatValue Resistance:weakself.currUser.resistance.integerValue];
                [weakself.weight readHistorys:weakself.currUser.userNo.integerValue ID:weakself.currUser.weightUserID];
                break;
            case CMDWS500SleepScale:
                [weakself addLogWhitText:@"Sleep Scale"];
                [weakself addLogWhitText:@"Disconnect"];
                [weakself.weight disconnect];
                break;
            case CMDWS500MeasurementResult:
                [weakself addLogWhitText:@"Measurement Result"];
                weakself.currUser.resistance = ((MicroLifeBodyFat *)model).resistance;
                [weakself saveNSUserDefaults:weakself.currUser.resistance Key:@"resistance"];
                break;
            case CMDWS500ReadHistorys:
                [weakself addLogWhitText:@"Read Historys"];
                weakself.currUser.resistance = ((MicroLifeBodyFat *)model).resistance;
                [weakself saveNSUserDefaults:weakself.currUser.resistance Key:@"resistance"];
                break;
            case CMDWS500UpdateUserInfo:
                [weakself addLogWhitText:@"Update UserInfo"];
                break;
            case CMDWS500ClearAllUserInfo:
                [weakself addLogWhitText:@"Clear All UserInfo"];
                break;
            case CMDWS500UploadCompleted:
                [weakself addLogWhitText:@"Upload Completed"];
                break;
            case CMDWS500LowPower:
                [weakself addLogWhitText:@"Low Power"];
                break;
            case CMDWS500SyncSystemClock:
                [weakself addLogWhitText:@"Sync System Clock"];
                break;
            default:
                break;
        }
    }];
}

- (void)connectBGM700 {
    kWeakSelf(self)
    self.bgm700 = [MicroLifeBGM700 shareWhithAuthorizationkey:SDKkey_BS];
    [self.bgm700 getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"BGM700 DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"BGM700 ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"BGM700 Cancel Scan"];
        [weakself.bgm700 startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"BGM700 Cancel All Devices Connection"];
        [weakself.bgm700 startScan];
    }];
    [self.bgm700 deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.bgm700];
        [weakself addLogWhitText:log];
    }];
    [self.bgm700 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bgm700 CMD:CMD Model:model Error:error];
    }];
}

- (void)connectBGM800 {
    kWeakSelf(self)
    self.bgm800 = [MicroLifeBGM800 shareWhithAuthorizationkey:SDKkey_BS];
    [self.bgm800 getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"BGM800 DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"BG8700 ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"BGM800 Cancel Scan"];
        [weakself.bgm800 startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"BGM800 Cancel All Devices Connection"];
        [weakself.bgm800 startScan];
    }];
    [self.bgm800 getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.bgm800 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.bgm800 CMD:CMD Model:model Error:error];
    }];
}

- (void)connectWatchBPOffice {
    kWeakSelf(self)
    self.watchBPOffice = [MicroLifeWatchBPOffice shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPOffice getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"watchBPOffice DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"watchBPOffice ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"watchBPOffice Cancel Scan"];
        [weakself.watchBPOffice startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"watchBPOffice Cancel All Devices Connection"];
        [weakself.watchBPOffice startScan];
    }];
    [self.watchBPOffice deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.watchBPOffice];
        [weakself addLogWhitText:log];
    }];
    [self.watchBPOffice getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPOffice CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPOfficeReadHistorys:
                [weakself.watchBPOffice disconnect];
                break;
            case CMDWatchBPOfficeReadUserAndVersionData:
                [weakself.watchBPOffice readAllHistorys];
                break;
            default:
                break;
        }
    }];
}

- (void)connectWatchBPOfficeLTC {
    kWeakSelf(self)
    self.watchBPM1 = [MicroLifeWatchBPM1 shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPM1 getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"watchBPM1 DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"watchBPM1 ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"watchBPM1 Cancel Scan"];
        [weakself.watchBPM1 startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"watchBPM1 Cancel All Devices Connection"];
        [weakself.watchBPM1 startScan];
    }];
    [self.watchBPM1 deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.watchBPM1];
        [weakself addLogWhitText:log];
    }];
    [self.watchBPM1 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPM1 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPM1ReadHistorys:
                [weakself.watchBPM1 disconnect];
                break;
            case CMDWatchBPM1ReadUserAndVersionData:
                [weakself.watchBPM1 readAllHistorys];
                break;
            default:
                break;
        }
    }];
}

- (void)connectWatchBPHome {
    kWeakSelf(self)
    self.watchBPHome = [MicroLifeWatchBPHome shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPHome getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"watchBPHome DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"watchBPHome ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"watchBPHome Cancel Scan"];
        [weakself.watchBPHome startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"watchBPHome Cancel All Devices Connection"];
        [weakself.watchBPHome startScan];
    }];
    [self.watchBPHome deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.watchBPHome];
        [weakself addLogWhitText:log];
    }];
    [self.watchBPHome getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.weight CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPHomeReadUsualModeHistoryData:
                [weakself.watchBPHome disconnect];
                break;
            case CMDWatchBPHomeReadUserAndVersionData:
                [weakself.watchBPHome readUsualModeHistoryData];
                break;
            default:
                break;
        }
    }];
}
- (void)connectWatchBPO3 {
    kWeakSelf(self)
    self.watchBPO3 = [MicroLifeWatchBPO3 shareWhithAuthorizationkey:SDKkey_WBP];
    [self.watchBPO3 getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"watchBPO3 DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"watchBPO3 ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"watchBPO3 Cancel Scan"];
        [weakself.watchBPO3 startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"watchBPO3 Cancel All Devices Connection"];
        [weakself.watchBPO3 startScan];
    }];
    [self.watchBPO3 deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.watchBPO3];
        [weakself addLogWhitText:log];
    }];
    [self.watchBPO3 getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.watchBPO3 CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDWatchBPO3ReadHistorys:
                [weakself.watchBPO3 disconnect];
                break;
            case CMDWatchBPO3ReadUserAndVersionData:
                [weakself.watchBPO3 readAllHistorys];
                break;
            default:
                break;
        }
    }];
}

- (void)connectPFM {
    kWeakSelf(self)
    self.peakFlowMeter = [MicroLifePFM shareWhithAuthorizationkey:SDKkey_PF];
    [self.peakFlowMeter getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"peakFlowMeter DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    } ScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"peakFlowMeter ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^{
        [weakself addLogWhitText:@"peakFlowMeter Cancel Scan"];
        [weakself.peakFlowMeter startScan];
    } ConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"BGM700 Cancel All Devices Connection"];
        [weakself.peakFlowMeter startScan];
    }];
    [self.peakFlowMeter deviceConnectedBlock:^{
        NSString *log = [NSString stringWithFormat:@"%@ Connected",weakself.peakFlowMeter];
        [weakself addLogWhitText:log];
    }];
    [self.peakFlowMeter getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.peakFlowMeter CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDPFMReadHistorys:
                [weakself.peakFlowMeter disconnect];
                break;
            case CMDPFMReadLastData:
                [weakself.peakFlowMeter readHistorys];
                break;
            case CMDPFMReadUserAndVersionData:
                [weakself.peakFlowMeter checkMode];
                break;
            case CMDPFMReadBestValue:
                [weakself.peakFlowMeter readLastData];
                break;
            case CMDPFMCheckMode:
                [weakself.peakFlowMeter readBestValue];
                break;
            default:
                break;
        }
    }];
}
@end
