//
//  OxygenViewController.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by willy.wu on 2021/8/20.
//  Copyright © 2021 WiFi@MBP. All rights reserved.
//

#import "OxygenViewController.h"

@interface OxygenViewController ()
@end

@implementation OxygenViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    [self connectOxygen];
    [self.sdk model:@[@"OXY560 BT", @"OXY1000 BT"]];
    [self.sdk device:@[self.oxygen]];
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
        [weakself scanDevice:device];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (NSMutableArray *)dataArray {
    if (!_dataArray) {
        self.dataArray = [NSMutableArray array];
    }
    return _dataArray;
}

#pragma mark - device
- (void)connectOxygen {
    kWeakSelf(self)
    self.oxygen = [MicroLifeOxygen shareWhithAuthorizationkey:SDKkey_SPO2];
    [self.oxygen getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.oxygen getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.oxygen CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDOxygenVolumeTracingData:
                [weakself showOxygen:model];
                break;
            case CMDOxygenSaturationAndPulseRateData:
            case CMDOxygenSaturationAndPulseRateAlarmLimits:
                break;
            default:
                break;
        }
    }];
}

- (void)scanDevice:(BLEDeviceInfo *)device {
    if ([device.name isEqualToString:@"OXY560 BT"]||[device.name isEqualToString:@"OXY1000 BT"]) {
        [device connectDevice];
    }
}

#pragma mark ---< CBCentralManagerDelegate >---
- (void)centralManagerDidUpdateState:(CBCentralManager *)central{
    NSLog(@"central.state = %ld", (long)central.state);
}

- (void)centralManager:(CBCentralManager *)central didDiscoverPeripheral:(CBPeripheral *)peripheral advertisementData:(NSDictionary *)advertisementData RSSI:(NSNumber *)RSSI {
    NSLog(@"%@,%@",peripheral.name,advertisementData);
}

- (void)centralManager:(CBCentralManager *)central didConnectPeripheral:(CBPeripheral *)peripheral{
    NSLog(@"connected");
}

- (void)centralManager:(CBCentralManager *)central didFailToConnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error{
    NSLog(@"didFailToConnectPeripheral,error:%@",error);
}

- (void)centralManager:(CBCentralManager *)central didDisconnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error{
    NSLog(@"didDisconnectPeripheral,error:%@",error);
}

#pragma mark --< ContecBluetoothDelegate >--
-(void)contec_getDeviceData:(NSDictionary *)dicDeviceData {
    [self addLogWhitText:[NSString stringWithFormat:@"dicDeviceData = %@", dicDeviceData.description]];
}

-(void)contec_getOperateResult:(NSDictionary *)dicOperateResult {
    [self addLogWhitText:[NSString stringWithFormat:@"dicOperateResult = %@",dicOperateResult.description]];
}

-(void)contec_getError:(NSDictionary *)dicError {
    [self addLogWhitText:[NSString stringWithFormat:@"dicError = %@", dicError.description]];
}

- (void)contec_receivedRealtimeValueData:(NSDictionary *)valueDic {
    [self addLogWhitText:[NSString stringWithFormat:@"valueDic %@", valueDic.description]];
}

- (void)contec_receivedRealtimeWaveData:(NSDictionary *)waveDic {
    [self addLogWhitText:[NSString stringWithFormat:@"waveDic = %@", waveDic.description]];
}

- (void)contec_receivedRealtimeRedLightData:(NSDictionary *)redLightDic {
    [self addLogWhitText:[NSString stringWithFormat:@"redLightDic = %@", redLightDic.description]];
}

- (void)contec_receivedCaseDataProgress:(NSInteger)progress {
    [self addLogWhitText:[NSString stringWithFormat:@"====================== %ld", (long)progress]];
}

#pragma mark - show 
- (void)showOxygen:(MicroLifeOxygenData *)model {
    if (self.dataArray.count > self.spoView.frame.size.width) {
        [self.dataArray removeObjectsInRange:NSMakeRange(0, model.spoDataArray.count)];
    }
    for (NSNumber *spo in model.spoDataArray) {
        [self.dataArray addObject:spo];
    }
    NSMutableArray *spoViewArray = [NSMutableArray array];
    float height = self.spoView.frame.size.height*0.5;
    for (NSInteger index = 0; index < self.dataArray.count; index++) {
        NSNumber *spo = self.dataArray[index];
        NSInteger spoV = spo.integerValue;
        [spoViewArray addObject:[NSValue valueWithCGPoint:CGPointMake(index, height-spoV)]];
    }
    [spoViewArray addObject:[NSNull null]]; // 断点
    self.spoView.showLayer.path = [AxcDrawPath AxcDrawLineArray:spoViewArray].CGPath;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
