//
//  PFMViewController.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by 吳憲有 on 2022/12/13.
//  Copyright © 2022 WiFi@MBP. All rights reserved.
//

#import "PFMViewController.h"

@interface PFMViewController ()

@end

@implementation PFMViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    [self connectPFM];
    [self.sdk device:@[self.peakFlowMeter]];
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
    }];
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

- (void)connectPFM {
    kWeakSelf(self)
    self.peakFlowMeter = [MicroLifePFM shareWhithAuthorizationkey:SDKkey_PF];
    [self.peakFlowMeter getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.peakFlowMeter getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.peakFlowMeter CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDPFMReadHistorys:
            case CMDPFMClearAllHistorys:
            case CMDPFMReadUserAndVersionData:
            case CMDPFMWriteUser:
            case CMDPFMReadLastData:
            case CMDPFMClearLastData:
            case CMDPFMReadDeviceTime:
            case CMDPFMWriteDeviceTime:
            case CMDPFMReadSerialNumber:
            case CMDPFMReadBestValue:
            case CMDPFMWriteBestValue:
            case CMDPFMCheckMode:
            case CMDPFMWaveformModeStartMeasurement:
            case CMDPFMWaveformModeReadWaveform:
                break;
            default:
                break;
        }
    }];
}

#pragma mark - IBAction
- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (sender.tag) {
        case 100:
            [self.peakFlowMeter readHistorys];
            break;
        case 101:
            [self.peakFlowMeter clearAllHistorys];
            break;
        case 102:
            [self.peakFlowMeter disconnect];
            break;
        case 103:
            [self.peakFlowMeter readUserAndVersionData];
            break;
        case 104:
        {
            NSString *ID = [self getBPMuserID];
            NSInteger age = [self getAge];
            [self saveNSUserDefaults:ID Key:@"pfmUserID"];
            [self.peakFlowMeter writeUserData:ID Age:age];
            log = [log stringByAppendingFormat:@"：%@ age:%ld",ID, age];
        }
            break;
        case 105:
            [self.peakFlowMeter readLastData];
            break;
        case 106:
            [self.peakFlowMeter clearLastData];
            break;
        case 107:
            [self.peakFlowMeter readDeviceTime];
            break;
        case 108:
            [self.peakFlowMeter writeDeviceTime];
            break;
        case 109:
            [self.peakFlowMeter readSerialNumber];
            break;
        case 110:
            [self.peakFlowMeter readBestValue];
            break;
        case 111:
        {
            NSInteger bv = arc4random_uniform(1000);
            log = [log stringByAppendingFormat:@"：%ld",bv];
            [self.peakFlowMeter writeBestValue:bv];
        }
            break;
        case 112:
            [self.peakFlowMeter checkMode];
            break;
        case 113:
            [self.peakFlowMeter waveformModeStartMeasurement];
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
