//
//  PPGViewController.m
//  MicroLifeDeviceSDK-Demo
//
//  Created by 吳憲有 on 2023/10/31.
//  Copyright © 2023 WiFi@MBP. All rights reserved.
//

#import "PPGViewController.h"

@interface PPGViewController ()

@end

@implementation PPGViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    kWeakSelf(self)
    [self connectPPG];
    [self.sdk device:@[self.ppg]];
    [self.sdk cancelScan];
    [self.sdk getDidUpdateStateBlock:^(CBManagerState state) {
        NSString *log = [NSString stringWithFormat:@"DidUpdateState：%ld",(long)state];
        [weakself addLogWhitText:log];
    }];
    [self.sdk getScanDeviceBlock:^(NSInteger checkMacType, id  _Nonnull device) {
        NSString *log = [NSString stringWithFormat:@"ScanDevice Name：%@ UUID：%@ mac：%@ checkMacType：%ld",[device name],[device UUID],[device mac],checkMacType];
        [weakself addLogWhitText:log];
    } CancelScanBlock:^() {
        [weakself addLogWhitText:@"Cancel Scan"];
        [weakself.temperature startScan];
    }];
    [self.sdk getConnectDeviceStateBlock:^(id  _Nonnull device, CBCentralManager * _Nonnull central, CBPeripheral * _Nonnull peripheral, CBPeripheralState state, NSError * _Nonnull error) {
        [weakself connectDeviceInfo:device PeripheralState:state];
    } CancelAllDevicesConnectionBlock:^{
        [weakself addLogWhitText:@"Cancel All Devices Connection"];
        [weakself.temperature startScan];
    }];
}

- (void)viewDidLayoutSubviews {
    self.butView.contentSize = CGSizeMake(self.butView.frame.size.width, self.butView.frame.size.height*5);
}

#pragma mark - IBAction
- (IBAction)startSacn:(id)sender {
    [self.view endEditing:YES];
    if (self.deviceName.text.length > 0) {
        [self.ppg addDeviceModel:@[self.deviceName.text]];
    }
    if (self.currDeviceInfo != nil) {
        [self.currDeviceInfo disconnectDevice];
    } else {
        [self.sdk cancelAllConnect];
    }
    [self.sdk startScan];
    [self addLogWhitText:@"startScan"];
    for (NSString *device in self.ppg.deviceModels) {
        [self addLogWhitText:device];
    }
}

- (IBAction)comAction:(UIButton *)sender {
    NSString *log = sender.titleLabel.text;
    switch (sender.tag) {
        case 100:
            [self.ppg readUsualModeHistoryData];
            break;
        case 101:
            [self.ppg readDiagnosticModeHistoryData];
            break;
        case 102:
        {
            BOOL usual = arc4random()%2;
            BOOL diagnostic = arc4random()%2;
            BOOL abpm = arc4random()%2;
            BOOL pill = arc4random()%2;
            log = [log stringByAppendingFormat:@":usual:%d diagnostic:%d abpm:%d pill:%d",usual,diagnostic,abpm,pill];
            [self.ppg clearSelectedModeHistoryData:usual DiagnosticMode:diagnostic ABPMMode:abpm PillMode:pill];
        }
            break;
        case 103:
        {
            MAPType type = arc4random()%2;
            log = [log stringByAppendingFormat:@":%ld",type];
            [self.ppg readABPMModeHistoryData:type];
        }
            break;
        case 104:
            [self.ppg disconnect];
            break;
        case 105:
        {
            NSString *UUIDString = [NSUUID UUID].UUIDString;
            UUIDString = [UUIDString stringByReplacingOccurrencesOfString:@"-" withString:@""];
            log = [log stringByAppendingFormat:@":%@",UUIDString];
            [self.ppg writeUserID:UUIDString];
        }
            break;
        case 106:
            [self.ppg readDeviceInfo];
            break;
        case 107:
            [self.ppg readDeviceTime];
            break;
        case 108:
            [self.ppg writeDeviceTime];
            break;
        case 109:
            [self.ppg readSerialNumber];
            break;
        case 110:
            [self.ppg readABPMModeSetting2Schedules];
            break;
        case 111:
        {
            NSArray *times = @[@(0),@(1),@(2),@(3),@(4),@(5),@(6),@(7),@(8),@(9),@(10),@(11),@(12),@(13),@(14),@(15),@(16),@(17),@(18),@(19),@(20),@(21),@(22),@(23)];
            NSInteger start = ((NSNumber *)times[arc4random()%times.count]).integerValue;
            NSInteger end = ((NSNumber *)times[arc4random()%times.count]).integerValue;
            NSArray *Intervals = @[@(MicroLifeInterval5),@(MicroLifeInterval10),@(MicroLifeInterval15),@(MicroLifeInterval20),@(MicroLifeInterval30),@(MicroLifeInterval60),@(MicroLifeIntervalOff)];
            Interval first = ((NSNumber *)Intervals[arc4random()%Intervals.count]).integerValue;
            Interval second = ((NSNumber *)Intervals[arc4random()%Intervals.count]).integerValue;
            NSArray *HIinfPressures = @[@(MicroLifeHIinfPressureAuto),@(MicroLifeHIinfPressure140),@(MicroLifeHIinfPressure160),@(MicroLifeHIinfPressure180),@(MicroLifeHIinfPressure200),@(MicroLifeHIinfPressure220),@(MicroLifeHIinfPressure240),@(MicroLifeHIinfPressure280)];
            HIinfPressure hi = ((NSNumber *)HIinfPressures[arc4random()%HIinfPressures.count]).integerValue;
            BOOL check = arc4random()%2;
            BOOL silent = arc4random()%2;
            log = [log stringByAppendingFormat:@":start:%ld end:%ld first:%ld second:%ld HI:%ld check:%d silent:%d",start,end,first,second,hi,check,silent];
            [self.ppg writeABPMModeSetting2SchedulesStart:start End:end firstInterval:first secondInterval:second HI_infPressure:hi SW_checkhide:check silent:silent];
        }
            break;
        case 112:
        {
            NSInteger offsetYear = arc4random()%10;
            log = [log stringByAppendingFormat:@":offsetYear:%ld",offsetYear];
            [self.ppg eraseAllMeasureAndErrorTimes:offsetYear];
        }
            break;
        default:
            break;
    }
    [self addLogWhitText:log];
}


#pragma mark - device
- (void)connectPPG {
    kWeakSelf(self)
    self.ppg = [MicroLifePPG shareWhithAuthorizationkey:SDKkey_PPG];
    [self.ppg getValidationErrorBlock:^(NSString * _Nonnull item, NSString * _Nonnull info, id _Nonnull value) {
        [weakself addLogWhitText:[NSString stringWithFormat:@"item: %@\ninfo: %@\nvalue: %@",item,info,value]];
    }];
    [self.ppg getReadDataValueBlock:^(NSInteger CMD, NSData * _Nonnull value, NSError * _Nonnull error) {
        [weakself log:weakself.ppg CMD:CMD Model:value Error:error];
    }];
    [self.ppg getReadDataModelBlock:^(NSInteger CMD, id  _Nonnull model, NSError * _Nonnull error) {
        [weakself log:weakself.ppg CMD:CMD Model:model Error:error];
        switch (CMD) {
            case CMDPPGReadUsualModeHistoryData:
            case CMDPPGReadDiagnosticModeHistoryData:
            case CMDPPGClearSelectedModeHistoryData:
            case CMDPPGReadABPMModeHistoryData:
            case CMDPPGDisconnect:
            case CMDPPGReadUserIDAndVersion:
            case CMDPPGWriteUserID:
            case CMDPPGWriteDeviceInfo:
            case CMDPPGReadDeviceInfo:
            case CMDPPGReadDeviceTime:
            case CMDPPGWriteDeviceTime:
            case CMDPPGReadDeviceStatus:
            case CMDPPGReadSerialNumber:
            case CMDPPGReadABPMModeSetting2Schedules:
            case CMDPPGWriteABPMModeSetting2Schedules:
            case CMDPPGReadABPMModeSetting5Schedules:
            case CMDPPGWriteABPMModeSetting5Schedules:
            case CMDPPGEraseAllMeasureAndErrorTimes:
            case CMDPPGReadMeterFunctionSetting:
            case CMDPPGWriteMeterFunctionSetting:
            case CMDPPGCalibrationBPQuery:
            case CMDPPGCADUBPCalibrationBPSet:
            case CMDPPGOpenBPDetectionTimer:
            case CMDPPGCloseBPDetectionTimer:
            case CMDPPGResetDevice:
                break;
            default:
                break;
        }

    }];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
