//
//  CloudDataModel.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/5/24.
//

#import <Foundation/Foundation.h>
#import <objc/runtime.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, AnalysisErrorCode) {
    AnalysisErrorNone = 0,
    AnalysisErrorNetwork = 1,              // 網路錯誤
    AnalysisErrorNoJSONFormat = 2,         // 找不到 JSON 格式
    AnalysisErrorInvalidJSONStructure = 3, // 無效 JSON 結構
    AnalysisErrorInvalidData = 4,          // 無效資料
    AnalysisErrorStringConversion = 5,     // 字串轉換錯誤
    AnalysisErrorJSONDataConversion = 6,   // JSON 資料轉換錯誤
    AnalysisErrorJSONParsing = 7           // JSON 解析錯誤
};

@interface CloudDataModel : NSObject

@property (nonatomic, strong) NSMutableDictionary *value;

/// Error analysis code used to identify different types of errors during data processing
@property (nonatomic, assign) AnalysisErrorCode errorAnalyze;

@property (nonatomic, strong) NSString *errorMessage;

+ (instancetype)shareWihtData:(NSData * _Nullable)data Error:(NSError * _Nullable)error;

#pragma Dictionary object conversion
/// Dictionary to model.
/// @param value Dictionary (NSDictionary) or json format character.
+ (instancetype)parseObjectWithKeyValues:(id)value;
+ (NSArray* _Nonnull)parseObjectArrayWithKeyValuesArray:(NSArray* const _Nonnull)array;

/// to Dictionary.
- (NSMutableDictionary *)parseDictionary;

//Get the type of a model object in an array
- (NSDictionary *)gainClassTypes;
@end

NS_ASSUME_NONNULL_END
