//
//  CloudManager.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/5/20.
//

#import <Foundation/Foundation.h>
#import <SafariServices/SafariServices.h>
#import <AuthenticationServices/AuthenticationServices.h>
#import <MicroLifeDeviceSDK/CloudDataModel.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^ValueBlock) (NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error);

typedef NS_ENUM(NSInteger, GrantType) {
    authorization_code = 0,
    refresh_token,
};

/**
 NetworkType

 - MicroLifeGET: <#MicroLifeGET description#>
 - MicroLifePOST: <#MicroLifePOST description#>
 - MicroLifePUT: <#MicroLifePUT description#>
 - MicroLifePATCH: <#MicroLifePATCH description#>
 - MicroLifeDELETE: <#MicroLifeDELETE description#>
 */
typedef NS_ENUM(NSInteger, MicroLifeNetworkType) {
    MicroLifeGET = 0,
    MicroLifePOST,
    MicroLifePUT,
    MicroLifePATCH,
    MicroLifeDELETE,
};

@interface CloudManager : NSObject <ASWebAuthenticationPresentationContextProviding>

@property (nonatomic, strong) NSMutableDictionary *headers;

/// <#Description#>
/// @param contentType <#contentType description#>
- (void)setCloudManagerContentType:(NSString *)contentType;

/// <#Description#>
/// @param timeStampFormat <#timeStampFormat description#>
- (void)setCloudManagerTimeStampFormat:(NSString *)timeStampFormat;

/// <#Description#>
/// @param timeoutInterval <#timeoutInterval description#>
- (void)setCloudManagerTimeoutInterval:(NSInteger)timeoutInterval;

/// <#Description#>
/// @param memoryCapacity <#memoryCapacity description#>
- (void)setCloudManagerMemoryCapacity:(NSInteger)memoryCapacity;

/// <#Description#>
/// @param diskCapacity <#diskCapacity description#>
- (void)setCloudManagerDiskCapacity:(NSInteger)diskCapacity;

#pragma mark - TimeStamp
/// <#Description#>
/// - Parameter cloudDataType: <#cloudDataType description#>
- (NSString *)readTimeStampWithCloudDataType:(NSString *)cloudDataType;

/// <#Description#>
/// - Parameter cloudDataType: <#cloudDataType description#>
- (void)saveTimeStampWithCloudDataType:(NSString *)cloudDataType;

/// <#Description#>
/// - Parameter cloudDataType: <#cloudDataType description#>
- (BOOL)checkTimestampWithCloudDataType:(NSString *)cloudDataType;

#pragma mark - NSUserDefaults存取類
/// <#Description#>
/// @param value <#value description#>
/// @param key <#key description#>
- (void)saveNSUserDefaults:(id)value Key:(NSString *)key;

/// <#Description#>
/// @param key <#key description#>
- (id)readNSUserDefaults:(NSString *)key;

/// <#Description#>
/// @param key <#key description#>
- (void)deleteNSUserDefaults:(NSString *)key;

#pragma mark - 解析請求參數
/// 把NSDictionary解析成post格式的NSString字符串
/// @param params <#params description#>
/// @param encode <#encode description#>
- (NSString *)ParseParams:(NSDictionary *)params URLEncode:(BOOL)encode;

/// 用NSDictionary來存參數，並轉換JSON格式
/// @param params <#params description#>
- (NSString *)JSONParams:(NSDictionary *)params;

/// 檔案上傳專用字典
/// @param key <#key description#>
/// @param filename <#filename description#>
/// @param fileData <#fileData description#>
- (NSMutableDictionary *)SetUploadFileDictWihtKey:(NSString *)key Filename:(NSString *)filename FileData:(NSData *)fileData;

/// 編譯上傳資訊數據
/// @param fileDicts <#fileDicts description#>
/// @param params <#params description#>
/// @param boundaryConstant <#boundaryConstant description#>
/// @param GET <#GET description#>
- (NSData *)getDataBodyWithFileArr:(NSMutableArray *)fileDicts RequestParams:(NSDictionary *)params BoundaryConstant:(NSString *)boundaryConstant GET:(BOOL)GET;

#pragma mark - SFSafariViewController
/// SFSafariViewController
/// @param vc <#vc description#>
/// @param URL <#URL description#>
/// @param completion <#completion description#>
+ (void)pushSFSafariViewController:(id)vc URL:(NSString *)URL animated:(BOOL)flag completion:(void (^ __nullable)(void))completion;

#pragma mark - ASWebAuthenticationSession
- (void)authenticateWithURL:(NSString *)urlString
             callbackScheme:(NSString *)callbackScheme
          completionHandler:(void(^)(NSURL * _Nullable callbackURL, NSError * _Nullable error))completionHandler;

- (void)authenticateWithURL:(NSString *)urlString
             callbackScheme:(NSString *)callbackScheme
    prefersEphemeralSession:(BOOL)prefersEphemeralSession
          completionHandler:(void(^)(NSURL * _Nullable callbackURL, NSError * _Nullable error))completionHandler;

- (void)authenticateOAuth2WithBaseURL:(NSString *)baseURL
                             clientID:(NSString *)clientID
                          redirectURI:(NSString *)redirectURI
                           parameters:(NSDictionary * _Nullable)parameters
              prefersEphemeralSession:(BOOL)prefersEphemeralSession
                    completionHandler:(void(^)(NSString * _Nullable authCode, NSError * _Nullable error))completionHandler;

- (void)cancelWebAuthentication;

#pragma mark - API
/// 異步請求封裝函數(NSURLSession)
/// @param type <#type description#>
/// @param URL <#URL description#>
/// @param params <#params description#>
/// @param JSON <#JSON description#>
/// @param block <#block description#>
- (void)NetworkDataTransType:(MicroLifeNetworkType)type URL:(NSString *)URL RequestHeaders:(NSDictionary * _Nullable)headers RequestParams:(NSDictionary * _Nullable)params JSON:(BOOL)JSON FinishBlock:(ValueBlock)block;

/// 多檔案上傳
/// @param URL <#URL description#>
/// @param fileDicts <#fileDicts description#>
/// @param params <#params description#>
/// @param GET <#GET description#>
/// @param block <#block description#>
- (void)UploadDataWithURL:(NSString *)URL RequestHeaders:(NSDictionary * _Nullable)headers FileArr:(NSMutableArray *)fileDicts RequestParams:(NSDictionary * _Nullable)params GET:(BOOL)GET FinishBlock:(ValueBlock)block;

#pragma mark - 下載
/// 下載
/// @param URL <#url description#>
/// @param cache <#url description#>
/// @param params <#params description#>
/// @param completion <#completion description#>
- (void)Download:(NSString *)URL Cache:(BOOL)cache RequestHeaders:(NSDictionary * _Nullable)headers RequestParams:(NSDictionary * _Nullable)params onCompletion:(void (^)(bool success, NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error))completion;

/// 下載
/// @param URL <#url description#>
/// @param params <#params description#>
/// @param completion <#completion description#>
- (void)Download:(NSString *)URL RequestHeaders:(NSDictionary * _Nullable)headers RequestParams:(NSDictionary * _Nullable)params onCompletion:(void (^)(NSURL * _Nullable location, NSURLResponse * _Nullable response, NSError * _Nullable error))completion;

/// 暫停下載
- (void)DownloadTaskSuspend;

/// 取消下載
- (void)DownloadTaskCancel;

#pragma mark - Log

@end

NS_ASSUME_NONNULL_END
