//
//  MicroLifeOxygen.h
//  MicroLifeDeviceSDK
//  
//  Created by willy.wu on 2020/12/16.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDOxygen) {
    CMDOxygenReadAlarmInfo = 0x01,
    CMDOxygenWriteAlarmInfo = 0x02,
    CMDOxygenVolumeTracingData = 0x80,
    CMDOxygenSaturationAndPulseRateData = 0x81,
    CMDOxygenSaturationAndPulseRateAlarmLimits = 0x82
};

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeOxygen : MicroLifeDevice

/// Read blood oxygen saturation and pulse rate alarm limit
-(void)readAlarmInfo;

/// Write blood oxygen saturation and pulse rate alarm limit
/// @param maxSPO The lower limit of blood oxygen alarm limit, the value is 50-100.
/// @param minSPO The upper limit of blood oxygen alarm limit, the value is 50-100.
/// @param maxPlus The lower limit of the pulse rate alarm limit, the value is 5-250. It must be a multiple of 5 and cannot be equal to 0.
/// @param minPlus The upper limit of the pulse rate alarm limit, the value is 5-250, must be a multiple of 5, and cannot be equal to 0.
-(void)alarmSPOMax:(NSInteger)maxSPO SPOmin:(NSInteger)minSPO PlusMax:(NSInteger)maxPlus Plusmin:(NSInteger)minPlus;

@end

NS_ASSUME_NONNULL_END
