//
//  MicroLifePPGDRecord.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2023/10/27.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifePPGDRecord : MicroLifeDataModel


/// Mode
/// 0x00: Usual mode
/// 0x01: Diagnostic mode
/// 0x02: ABPM mode
@property (nonatomic, strong) NSNumber *mode;

/// Indicates the total count or of blood pressure measurements stored in the mode.
@property (nonatomic, strong) NSNumber *historyMeasurementNumber;

/// All menasurement data
@property (nonatomic, strong) NSMutableArray *MData;

/// The overall average of the mode (excluding data from the first day)
@property (nonatomic, strong) id avgAll;

/// The average during the morning period in the mode (excluding data from the first day)
@property (nonatomic, strong) id avgM;

/// The average during the night period in the mode (excluding data from the first day)
@property (nonatomic, strong) id avgE;

// The last day counts accumulated in the "Diagnostic mode"
@property (nonatomic, strong) NSNumber *DiagDAYCount;

/// its measure times of 1 day in diagnostic mode.
@property (nonatomic, strong) NSNumber *DiagTimes;

/// Distinguish the store data in diagnostic mode is full.
@property (nonatomic, strong) NSNumber *DiagOver;

/// MAP Type:
/// 0: Oscillometric MAP
/// 1: Formula MAP (MAP=1/3 SYS+ 2/3 DIA)
@property (nonatomic, assign) MAPType mapType;

@end

NS_ASSUME_NONNULL_END
