//
//  MicroLifeWatchBPO3.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/5.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWatchBPO3) {
    CMDWatchBPO3ReadHistorys = 0x00,
    CMDWatchBPO3ReadCBPData = 0x01,
    CMDWatchBPO3ClearAllHistorys = 0x03,
    CMDWatchBPO3Disconnect = 0x04,
    CMDWatchBPO3ReadUserAndVersionData = 0x05,
    CMDWatchBPO3WriteUser = 0x06,
    CMDWatchBPO3ReadSettingValues = 0x07,
    CMDWatchBPO3WriteSettingValues = 0x08,
    CMDWatchBPO3ReadDeviceInfo = 0x0B,
    CMDWatchBPO3ReadDeviceTime = 0x0C,
    CMDWatchBPO3WriteDeviceTime = 0x0D,
    CMDWatchBPO3ReadSerialNumber = 0x0F,
    CMDWatchBPO3ReadFunctionSettingValue = 0x10,
    CMDWatchBPO3ReadBTModuleName = 0x13,
    CMDWatchBPO35SReadSettingValues = 0x14,
    CMDWatchBPO35SWriteSettingValues = 0x15,
    CMDWatchBPO3ReplyACK = 0x81,
    CMDWatchBPO3ReplyNACK = 0x91,
    CMDWatchBPO3ReplyNullACK = 0x92
};
NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPO3 : MicroLifeDevice

/**
 Read all history or current data from bpm
 */
- (void)readAllHistorys;

/**
 Read CBP data by index from BPM
 
 @param index Data format which APP requested
 @param dformat Data format which APP requested
 */
- (void)readCBPDataWithIndex:(NSInteger)index Dformat:(Dformat)dformat;

/**
 Clear all history data of the BPM
 */
- (void)clearAllHistorys;

/**
 Disconnect the Bluetooth with BPM
 */
- (void)disconnect;

/**
 Read user ID and version data from BPM
 */
- (void)readUserAndVersionData;

/**
 Write a new user ID to BPM
 
 @param ID user ID
 */
- (void)writeUserID:(NSString *)ID;

/**
 Read ABPM setting values from BPM
 */
- (void)readSettingValues;

///  Write ABPM setting values to BPM.
/// @param ABPMStart The starting time of the first measurement time zone
/// @param ABPMEnd The end time of the first measurement time zone
/// @param ABPMInt_first The interval of the first measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
/// @param ABPMInt_second The interval of the second measurement time zone (valid range: 5, 10, 15, 20, 30, and 60)
/// @param HI_infPressure  Highest inflation pressure of Auto mode
/// @param SW_checkhide The interval of the CBP first measurement time zone  Note:  CBPInt_first should multiple time than ABPMInt_first.
/// @param SW_SEL_silent Hide(true)/Show(false) readings after measurement
/// @param CBP_zone1_meas_off the first time zone of CBP measurement true:disabled/false:enabled
/// @param CBP_zone2_meas_off the second time zone of CBP measurement true:disabled/false:enabled
/// @param CBPInt_first The interval of the CBP first measurement time zone (valid range: 5, 10, 15, 20, 30, and 60) Note:  CBPInt_first should multiple time than ABPMInt_first.
/// @param CBPInt_second The interval of the CBP second measurement time zone (valid range: 5, 10, 15, 20, 30, and 60) Note:  CBPInt_second should multiple time than ABPMInt_second.
- (BOOL)writeSettingValuesWithSelectedABPMStart:(NSInteger)ABPMStart ABPMEnd:(NSInteger)ABPMEnd ABPMInt_first:(MeasurementTime)ABPMInt_first ABPMInt_second:(MeasurementTime)ABPMInt_second HI_infPressure:(HIinfPressure)HI_infPressure SW_checkhide:(BOOL)SW_checkhide SW_SEL_silent:(BOOL)SW_SEL_silent CBP_zone1_meas_off:(BOOL)CBP_zone1_meas_off CBP_zone2_meas_off:(BOOL)CBP_zone2_meas_off CBPInt_first:(MeasurementTime)CBPInt_first CBPInt_second:(MeasurementTime)CBPInt_second;

/// Write Setting Values from BPM(5 schedule)
/// @param settingValues MicroLifeWatchBPSettingValues
/// @param HI_infPressure HI_infPressure
/// @param SW_checkhide SW_checkhide
- (BOOL)writeSettingValuesWithSettingValues:(NSMutableArray *)settingValues HI_infPressure:(HIinfPressure)HI_infPressure SW_checkhide:(BOOL)SW_checkhide;

/**
 Read device ID and info from BPM
 */
- (void)readDeviceIDAndInfo;

/**
 Read device Time from BPM
 */
- (void)readDeviceTime;

/**
 Write device Time to BPM
 */
- (void)writeDeviceTime;

/**
 Read BPM function setting value from BPM
 */
- (void)readFunctionSettingValue;

/**
 Read BT module name from BPM
 */
- (void)readBTModuleName;

/**
  Read device SN from BPM

 */
- (void)readSerialNumber;
@end

NS_ASSUME_NONNULL_END
