//
//  MicroLifeWatchBPRemoteMeasurement.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2021/10/19.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPRemoteMeasurement : MicroLifeDataModel

@property (nonatomic, assign) Dformat dformat;

@property (nonatomic, assign) STATUS status;

/// Send current measurement number in auto mode.
@property (nonatomic, strong) NSNumber *measurementNumber;

/// Send total measurement number in auto mode.
@property (nonatomic, strong) NSNumber *totalMeasurementNumber;

/// Send current countdown time in auto mode.
@property (nonatomic, strong) NSNumber *countdown;

/// Send total measurement time (seconds) in auto mode. Total measurement are count between 1st measurement to last measurement. (exclude rest time)
@property (nonatomic, strong) NSNumber *totalMeasuretime;

/// The history measurement times store in memory.
@property (nonatomic, strong) NSNumber *historyMeasurementNumber;

/// Send current measurement times to APP.
@property (nonatomic, strong) NSNumber *currentMeasurementTimes;

///  Send Average calculation when measurement to APP.
@property (nonatomic, strong) NSNumber *isAverage;


@end

NS_ASSUME_NONNULL_END
