//
//  MicroLife5GBP.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2020/12/7.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger , CMD5G) {
    CMD5GReadHistorys = 0x00,
    CMD5GClearAllHistorys = 0x03,
    CMD5GDisconnect = 0x04,
    CMD5GReadUserAndVersionData = 0x05,
    CMD5GWriteUser = 0x06,
    CMD5GReadLastData = 0x07,
    CMD5GClearLastData = 0x08,
    CMD5GReadDeviceInfo = 0x0B,
    CMD5GReadDeviceTime = 0x0C,
    CMD5GSyncTiming = 0x0D,
    CMD5GCheckTransmit = 0x0E,
    CMD5GReadSerialNumber = 0x0F,
    CMD5GReplyACK = 0x81,
    CMD5GReplyNACK = 0x91,
    CMD5GReplyNullACK = 0x92
};

@interface MicroLife5GBP : MicroLifeDevice

/// read all history or current data from bpm
-(void)readHistorys;

/// clear all history data from bpm
- (void)clearAllHistorys;

/// disconnect
- (void)disconnect;

/// read user id and version data from bpm
- (void)readUserAndVersionData;

/// write a new user id & age
/// @param ID userID (Must be a 9-digit string 2-english string)
/// @param age age
- (void)writeUserData:(NSString *)ID Age:(NSInteger)age;

/// read Device information
- (void)readDeviceInfo;

///  Read device Time from BPM
- (void)readDeviceTime;

/// Synchronize device time
- (void)syncTiming;

/// Check Transmit
- (void)checkTransmit;

/// Read last 1 data from the BPM
- (void)readLastData;

/// Clear last 1 data of the BPM
- (void)clearLastData;

///Read device SN from BPM
- (void)readSerialNumber;

@end

NS_ASSUME_NONNULL_END
