//
//  MicroLifeCloudDataModel.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/5/24.
//

#import <MicroLifeDeviceSDK/CloudDataModel.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeCloudDataModel : CloudDataModel

@property (nonatomic, assign) NSInteger code;
@property (nonatomic, strong) NSString *info;
@property (nonatomic, assign) NSInteger ID;

@property (nonatomic, assign) NSInteger account_id;
@property (nonatomic, assign) NSInteger total_num;
@property (nonatomic, strong) id  data;

@property (nonatomic, strong) NSString * access_token;
@property (nonatomic, strong) NSString * expires_in;
@property (nonatomic, strong) NSString * token_type;
@property (nonatomic, strong) NSString * refresh_token;

@property (nonatomic, strong) NSString * error;
@property (nonatomic, strong) NSString * Message;

@property (nonatomic, strong) NSString * api_key;
@property (nonatomic, strong) NSString * sys_id;

@property (nonatomic, strong) NSString * photo;
@property (nonatomic, strong) NSString * recording;

@property (nonatomic, strong) NSString * pdf_path;

@property (nonatomic, strong) NSArray * bpm;
@property (nonatomic, strong) NSArray * bt;
@property (nonatomic, strong) NSArray * weight;
@property (nonatomic, strong) NSArray * oxymeter;
@property (nonatomic, strong) NSArray * peakflow;

@property (nonatomic, assign) NSString * import_id;
@property (nonatomic, strong) NSString * status;

@property (nonatomic, assign) NSInteger contacsupportid;

@property (nonatomic, strong) NSString * authorization_code;

@property (nonatomic, strong) NSString * api_Lang;

+ (instancetype)initWihtData:(NSData * _Nullable)data Error:(NSError * _Nullable)error;

@end

NS_ASSUME_NONNULL_END
