//
//  MicroLifeECGDeviceCurrentStatus.h
//  MicroLifeDeviceSDK
//
//  Created by willy.wu on 2022/7/25.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeECGDeviceCurrentStatus : MicroLifeDataModel


/// Device status：
/// Note: Refer to 2.1.3 ECG measurement flowchart, device will auto update device status (0x05~0x08) during ECG measurement. But if stop ECG measurement, device will stop auto to update status.
@property (nonatomic, assign) ECGStatus DeviceStatus;

/// Retry Times: valid range: 0~3 , 255:N/A
@property (nonatomic, strong) NSNumber *RetryTimes;

/// ECG code:
@property (nonatomic, assign) ECGcode ECGcode;

/// EINT
@property (nonatomic, strong) NSNumber *EINT;

/// EOVF
@property (nonatomic, strong) NSNumber *EOVF;

/// DCLOFFINT
@property (nonatomic, strong) NSNumber *DCLOFFINT;

/// LONINT
@property (nonatomic, strong) NSNumber *LONINT;

/// RRINT
@property (nonatomic, strong) NSNumber *RRINT;

/// SAMP
@property (nonatomic, strong) NSNumber *SAMP;

/// PLLINT
@property (nonatomic, strong) NSNumber *PLLINT;

/// LDOFF_PH
@property (nonatomic, strong) NSNumber *LDOFF_PH;

/// LDOFF_PL
@property (nonatomic, strong) NSNumber *LDOFF_PL;

/// LDOFF_NH
@property (nonatomic, strong) NSNumber *LDOFF_NH;

/// LDOFF_NL
@property (nonatomic, strong) NSNumber *LDOFF_NL;

/// LDOFF
@property (nonatomic, strong) NSNumber *LDOFF;

/// Wait counter:
/// If lead-off, device will wait 30 second until user lead on. Maybe reset by lead-on.
@property (nonatomic, strong) NSNumber *waitCounter;

/// Lead stable counter
/// If lead-on, device will wait 4 second to start. Maybe reset by lead-off.
@property (nonatomic, strong) NSNumber *LeadStableCounter;

/// Start Year
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *year;

/// Start Month
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *month;

/// Start Date
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *day;

/// Start Hour
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *hour;

/// Start Minte
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *minute;

/// Start Second
/// These parameters describes the start time stamp for ECG measurement , If error-occurred, device will re-try 3 times and update new start time stamp
@property (nonatomic, strong) NSNumber *second;
@end

NS_ASSUME_NONNULL_END
