//
//  MicroLifeWatchBPOfficeVascular.h
//  MicroLifeDeviceSDK
//
//  Created by 吳憲有 on 2025/5/26.
//

#import <MicroLifeDeviceSDK/MicroLifeDeviceSDK.h>

typedef NS_ENUM(NSInteger , CMDWatchBPOfficeVascular) {
    CMDWatchBPOfficeVascularReadHistorys = 0x00,
    CMDWatchBPOfficeVascularReadCBPAndPWVData = 0x01,
    CMDWatchBPOfficeVascularClearAllHistorys = 0x03,
    CMDWatchBPOfficeVascularDisconnect = 0x04,
    CMDWatchBPOfficeVascularReadUserAndVersionData = 0x05,
    CMDWatchBPOfficeVascularWriteUser = 0x06,
    CMDWatchBPOfficeVascularReadSettingValues = 0x07,
    CMDWatchBPOfficeVascularWriteSettingValues = 0x08,
    CMDWatchBPOfficeVascularReadDeviceInfo = 0x0B,
    CMDWatchBPOfficeVascularReadDeviceTime = 0x0C,
    CMDWatchBPOfficeVascularWriteDeviceTime = 0x0D,
    CMDWatchBPOfficeVascularReadFunctionSettingValue = 0x10,
    CMDWatchBPOfficeVascularReadBTModuleName = 0x13,
    CMDWatchBPOfficeVascularStartRemoteMeasurement = 0x25,
    CMDWatchBPOfficeVascularStopRemoteMeasurement = 0x26,
    CMDWatchBPOfficeVascularSendRemoteMeasurementStatusEvery5seconds = 0x27,
    CMDWatchBPOfficeVascularReplyACK = 0x81,
    CMDWatchBPOfficeVascularReplyNACK = 0x91,
    CMDWatchBPOfficeVascularReplyNullACK = 0x92
};

/**
 DeviceMode: Device measurement mode configuration.
 
 - MicroLifeDeviceModeRA: right arm
 - MicroLifeDeviceModeLA: left arm
 - MicroLifeDeviceModeRALA: right arm & left arm
 - MicroLifeDeviceModeRALL: right arm & left leg
 - MicroLifeDeviceModeRARL: right arm & right leg
 - MicroLifeDeviceModeLARL: left arm & right leg
 */
typedef NS_ENUM(NSInteger, DeviceMode) {
  MicroLifeDeviceModeRA      = 0x00,
  MicroLifeDeviceModeLA      = 0x01,
  MicroLifeDeviceModeRALA    = 0x02,
  MicroLifeDeviceModeRALL    = 0x03,
  MicroLifeDeviceModeRARL    = 0x04,
  MicroLifeDeviceModeLARL    = 0x05,
};

/**
Dformat:Data format which APP requested.

- MicroLifeDNoCBPRaw: No CBP raw data
- MicroLifeDLowCBPRaw: low resolution CBP data (sampling rate =16Hz)
- MicroLifeDFullCBPRaw: full CBP raw data (sampling rate=256Hz)
- MicroLifeOVDFullPWVRaw: full PWV raw data (sampling rate=1024 Hz) (invalid command)
*/
typedef NS_ENUM(NSInteger, OVDformat) {
    MicroLifeOVDNoCBPRaw      = 0x00,
    MicroLifeOVDLowCBPRaw     = 0x01,
    MicroLifeOVDFullCBPRaw    = 0x02,
    MicroLifeOVDFullPWVRaw    = 0x03
};

/**
 STATUS:

 - MicroLifeMeasurementWait: device wait countdown for next measurement
 - MicroLifeMeasurementStart: device is start BP measurement
 - MicroLifeMeasurementStop: manual press I/O to stop measurement
 - MicroLifeOVMeasurementOccurredLowBattery: occurred low battery before measurement
 */
typedef NS_ENUM(NSInteger, OVSTATUS) {
    MicroLifeOVMeasurementWait    = 0x01,
    MicroLifeOVMeasurementStart   = 0x02,
    MicroLifeOVMeasurementStop    = 0x04,
    MicroLifeOVMeasurementOccurredLowBattery = 0x05,
};

NS_ASSUME_NONNULL_BEGIN

@interface MicroLifeWatchBPOfficeVascular : MicroLifeDevice

/**
 Read all history or current data from bpm
 */
- (void)readAllHistorys;

/**
 Read CBP data by index from BPM
 
 @param index Data format which APP requested
 @param dformat Data format which APP requested
 */
- (void)readCBPDataWithIndex:(NSInteger)index Dformat:(Dformat)dformat;

/**
 Clear all history data of the BPM
 */
- (void)clearAllHistorys;

/**
 Disconnect the Bluetooth with BPM
 */
- (void)disconnect;

/**
 Read user ID and version data from BPM
 */
- (void)readUserAndVersionData;

/**
 Write a new user ID to BPM
 
 @param ID user ID
 */
- (void)writeUserID:(NSString *)ID;

/**
 Read BPM setting values from BPM
 */
- (void)readSettingValues;

/// Write BPM setting values to BPM.
/// @param AUS_HI_infPressure Highest inflation pressure of AUS mode.
/// @param HI_infPressure Highest inflation pressure of Auto mode.
/// @param SW_AUTO_hide Set Show readings during rest time in auto mode. true:hide/false:show.
/// @param SW_SEL_silent Beeper true:enabled/false:disabled
/// @param SW_AUS_Hide Set Show cuff pressure during deflation in AUS mode. true:hide/false:show.
/// @param SW_AVG_no_include_first Set Average is include first memory data. true:is/false:is not.
/// @param SW_CBP Set CBP measurement  true:enabled/false:disabled.
/// @param SW_AFib Set AFib measurement  true:enabled/false:disabled.
/// @param SW_AMPM Set 12/24-hour clock true:12-hour/false:24-hour.
/// @param SW_Kpa Set Pressure unit: true:Kpa/false:mmHg.
/// @param RestTime Rest time of auto mode. Start countdown base on rest time before 1st measurement in auto mode.
/// @param IntervalTime Interval time of auto mode. Start countdown base on interval time before 2nd~6th measurement in auto mode.
/// @param AutoMeasureNumber It’s number of measurements in auto mode.

- (void)writeSettingValuesWithSelectedAUS_HI_infPressure:(HIinfPressure)AUS_HI_infPressure HI_infPressure:(HIinfPressure)HI_infPressure SW_AUTO_hide:(BOOL)SW_AUTO_hide SW_SEL_silent:(BOOL)SW_SEL_silent SW_AUS_Hide:(BOOL)SW_AUS_Hide SW_AVG_no_include_first:(BOOL)SW_AVG_no_include_first SW_CBP:(BOOL)SW_CBP SW_AFib:(BOOL)SW_AFib SW_AMPM:(BOOL)SW_AMPM SW_Kpa:(BOOL)SW_Kpa RestTime:(NSInteger)RestTime IntervalTime:(NSInteger)IntervalTime AutoMeasureNumber:(NSInteger)AutoMeasureNumber;

/**
 Read device ID and info from BPM
 */
- (void)readDeviceIDAndInfo;

/**
 Read device Time from BPM
 */
- (void)readDeviceTime;

/**
 Write device Time to BPM
 */
- (void)writeDeviceTime;

/**
 Read BPM function setting value from BPM
 */
- (void)readFunctionSettingValue;

/**
 Read BT module name from BPM
 */
- (void)readBTModuleName;

/**
 Start remote measurement
 After measurement device will auto send command 28h (send measurement results).
 If with CBP/ABI (PWV) measurement, device will send command 01h (send CBP/ ABI(PWV) wave)
 after command 28h.
 
 @param deviceMode DeviceMode
 @param dformat Data format which APP requested
 */
- (void)startRemoteMeasurementWhtihDeviceMode:(DeviceMode)deviceMode CBPFunction:(OVDformat)dformat;


- (void)startRemoteMeasurementStatusEvery5secondsWithSTATUS:(OVSTATUS)STATUS MeasurementNumbe:(NSInteger)measurementNumbe TotalMeasurementNumber:(NSInteger)totalMeasurementNumber Countdown:(NSInteger)countdown TotalMeasuretime:(NSInteger)totalMeasuretime;

/**
 Stop remote measurement
 */
- (void)stopRemoteMeasurement;

@end

NS_ASSUME_NONNULL_END
